/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CHTTPXcertServer.h,v 1.4 2000/07/10 22:05:00 dallen Exp $
____________________________________________________________________________*/

#ifndef Included_CHTTPXcertServer_h
#define Included_CHTTPXcertServer_h

#include "CHTTPKeyServer.h"

class CHTTPXcertServer : public CHTTPKeyServer {
public:
					CHTTPXcertServer(PGPContextRef inContext,
						const char * inHostName, PGPUInt32 inHostAddress,
						PGPUInt16 inHostPort, const char * inPath,
						PGPKeyServerProtocol inProtocol,
						PGPKeyServerClass inClass);
	virtual			~CHTTPXcertServer();
	
	virtual void	SendCertificateRequest(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inRequestKey,
						const void * inBuffer, PGPSize inBufferSize, void ** outBuffer,
						PGPSize * outBufferSize);
	virtual void	RetrieveCertificate(PGPFilterRef inSearchFilter, PGPKeyDBObjRef inSearchKey,
						PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inSigningKey, PGPByte * inPassphrase,
						PGPSize inPassphraseLength, PGPBoolean inIsPassphrase,
						void ** outBuffer, PGPSize * outBufferSize);
	virtual void	RetrieveCRL(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inSigningKey,
						PGPByte * inPassphrase, PGPSize inPassphraseLength,
						PGPBoolean inIsPassphrase, void ** outBuffer, PGPSize * outBufferSize);
	
protected:
	PGPUInt32		DigestKey(PGPKeyDBObjRef inKey, char * inOutputBuffer);
	PGPUInt32		GetMaxDigestedKeyBufferSize() { return GetMaxHexEncodedBufferSize(16); }

	void			ProcessSendCertResult(const char * inResult, void ** outBuffer,
						PGPSize * outBufferSize);
	void			ProcessRetrieveCertResult(const char * inResult, void ** outBuffer,
						PGPSize * outBufferSize);
	void			ProcessRetrieveCRLResult(const char * inResult, void ** outBuffer,
						PGPSize * outBufferSize);
};



#endif
